#!/bin/csh

gofer
ifort -o read read.f90

foreach scan (`ls -1 KBYX*`)

setenv BATCH_MODE
setenv INPUT_FORMAT "WSR_88D_FORMAT"
setenv OUTPUT_FLAGS "NETCDF_DATA NO_CATALOG"
setenv NETCDF_DIRECTORY .
#setenv DORADE_DIR .
#setenv OUTPUT_FLAGS "SWEEP_FILES"
setenv RADAR_NAME "KBYX"
setenv SOURCE_DEV "$scan"
xltrsii

set count = 0

foreach file (`ls -1 ncswp*.nc`)

@ count ++

set dd = `echo $file | cut -b 18,19` 
set hh = `echo $file | cut -b 21,22`
set mm = `echo $file | cut -b 23,24`
set ss = `echo $file | cut -b 25-30`

if ($count == 1) then
echo $dd, $hh, $mm, $ss >> katrina_dtg.dat
echo 2005, $dd, $hh, $mm, $ss >> katrina_scan_times.dat
endif

echo $file, $dd, $hh, $mm, $ss  >> katrina_files.txt

end

idl < run
ferret -script re-grid.jnl

ferret -script storm_centered.jnl



rm -f katrina_dtg.dat
rm -f katrina_files.txt
rm -f *.nc

echo FINISHED PROCESSING VOLUME SCAN: $scan
end

./read
